function b64ToU8(b64) {
  const bin = self.atob(b64);
  const u8 = new Uint8Array(bin.length);
  for (let i = 0; i < bin.length; i++) u8[i] = bin.charCodeAt(i);
  return u8;
}

function hexToU8(hex) {
  if (hex.length % 2 !== 0) throw new Error("Invalid hex");
  const u8 = new Uint8Array(hex.length / 2);
  for (let i = 0; i < u8.length; i++) {
    u8[i] = parseInt(hex.slice(i * 2, i * 2 + 2), 16);
  }
  return u8;
}

async function importAesGcmKeyFromHex(hexKey) {
  const raw = hexToU8(hexKey); // 32 bytes = AES-256
  return crypto.subtle.importKey(
    "raw",
    raw,
    { name: "AES-GCM" },
    false,
    ["decrypt"]
  );
}

/**
 * 解密 proxy.json
 * PHP 端格式：base64(iv(12) + tag(16) + ciphertext)
 */
export async function decryptProxyList(base64Blob, hexKey) {
  const blob = b64ToU8(base64Blob);

  const iv = blob.slice(0, 12);
  const tag = blob.slice(12, 28);
  const ciphertext = blob.slice(28);

  // WebCrypto 要 ciphertext||tag
  const data = new Uint8Array(ciphertext.length + tag.length);
  data.set(ciphertext, 0);
  data.set(tag, ciphertext.length);

  const key = await importAesGcmKeyFromHex(hexKey);

  const plainBuf = await crypto.subtle.decrypt(
    { name: "AES-GCM", iv, tagLength: 128 },
    key,
    data
  );

  const text = new TextDecoder().decode(new Uint8Array(plainBuf));
  return JSON.parse(text);
}
